<?php
require_once __DIR__ . '/config.php';
require_once __DIR__ . '/db.php';

// Update existing attachments to have sort_order based on uploaded_at
try {
    $stmt = $db->query("SELECT id, post_id FROM attachments ORDER BY post_id, uploaded_at");
    $attachments = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    $current_post_id = null;
    $sort_order = 0;
    
    foreach ($attachments as $attachment) {
        // Reset sort order when we move to a new post
        if ($attachment['post_id'] != $current_post_id) {
            $current_post_id = $attachment['post_id'];
            $sort_order = 0;
        }
        
        // Update the sort order for this attachment
        $update_stmt = $db->prepare("UPDATE attachments SET sort_order = ? WHERE id = ?");
        $update_stmt->execute([$sort_order, $attachment['id']]);
        
        $sort_order++;
    }
    
    echo "Attachment sort orders updated successfully.\n";
} catch (Exception $e) {
    echo "Error updating attachment sort orders: " . $e->getMessage() . "\n";
}